#include <cstdio>
#include <iostream>
#include <cmath>
#include <algorithm>
#include <vector>
#include <map>
#include <cstring>
#include <string>
#include <set>
#include <iomanip>
using namespace std;
#define fname ""
#define forit(it, s) for(__typeof(s.begin()) it = s.begin(); it != s.end(); it++)
#define all(s) s.begin(),s.end()
#define pb push_back
#define mp make_pair
#define F first
#define S second
const int maxn = (int)1e6;
const int inf = (1 << 30) - 1;

double det(double x, double y, double z, double t) {
	return x * t - y * z;
}

struct expr {
	bool point;
	double A, B, C;
	expr() { A = B = C = 0; point = 1; }
	expr(double A, double B) : A(A), B(B) { point = 1; }
	expr const operator * (const expr& t) const {
		expr r;
		r.point = 1;
		if (point && t.point) { // point to point
			r.A = t.B - B;
			r.B = A - t.A;
			r.C = -(r.A * A + r.B * B);
			r.point = 0;
		}
		if (point && !t.point) { // point to line
			double x = A, y = B;
			double d = (t.A * x + t.B * y + t.C) / (t.A * t.A + t.B * t.B);
			r.A = x - 2 * d * t.A;
			r.B = y - 2 * d * t.B;
		}
		if (!point && t.point) { // line to point
			double x = t.A, y = t.B;
			double d = (A * x + B * y + C) / (A * A + B * B);
			r.A = x - 2 * d * A;
			r.B = y - 2 * d * B;
		}
		if (!point && !t.point) { // line to line
			double dt = det(A, B, t.A, t.B);
			r.A = - det(C, B, t.C, t.B) / dt;
			r.B = - det(A, C, t.A, t.C) / dt;
		}
		return r;
	}
	
};

string s;
int it, n;

int getInt() {
	int res = 0, sgn = 1;
	if (s[it] == '-') {
		it++;
		sgn = -1;
	}
	while (it < n && '0' <= s[it] && s[it] <= '9')
		res = res * 10 + s[it++] - '0';
	return res * sgn;
}

expr parseE();

expr parse() {
	expr cur;
	if (s[it] == '(') {
		it++;
		cur = parseE();
		it++;
	}
	else {
		double x = (double)getInt();
		it++; // ,
		double y = (double)getInt();
		cur = expr(x, y);
	}
	return cur;
}

expr parseE() {
	expr cur = parse();
	while (it < n && s[it] == '@') {
		it++;
		cur = cur * parse();
	}
	return cur;
}


int main()
{
//	freopen(fname"in", "r", stdin);
//	freopen(fname"out", "w", stdout);

	while (cin >> s) {
		if (s[0] == '#') 
			break;
		it = 0;
		n = s.length();
		expr ans = parseE();
		printf("%.4f %.4f\n", ans.A, ans.B);
	}
	

	return 0;
}


